/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.ai;

import Krasnodar.rockstarnew.framework.msdf.Fonts;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.game.AttackEvent;
import Krasnodar.rockstarnew.systems.event.impl.player.ClientPlayerTickEvent;
import Krasnodar.rockstarnew.systems.event.impl.render.HudRenderEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_746;

@ModuleInfo(name="Recorder", category=ModuleCategory.OTHER)
public class RotationCollector
extends BaseModule {
    private static final long LOG_WINDOW_MS = 1500L;
    private final List<HashMap<String, Object>> dataset = new ArrayList<HashMap<String, Object>>();
    private float lastYaw;
    private float lastPitch;
    private float prevYaw;
    private float prevPitch;
    private float prevTargetYaw;
    private float prevTargetPitch;
    private float prevDistance;
    private long lastSwingTimeMs;
    private class_1297 lastTarget;
    private final EventListener<AttackEvent> onAttackEvent = event -> {
        long now;
        this.lastSwingTimeMs = now = System.currentTimeMillis();
        class_1297 target = event.getEntity();
        if (target != null) {
            this.lastTarget = target;
            class_746 p = class_310.method_1551().field_1724;
            if (p != null) {
                this.lastYaw = p.method_36454();
                this.lastPitch = p.method_36455();
            }
        } else {
            this.lastTarget = null;
        }
    };
    private final EventListener<HudRenderEvent> onHudRender = event -> {
        long now = System.currentTimeMillis();
        if (this.lastTarget != null && now - this.lastSwingTimeMs <= 1500L && this.lastTarget.method_5805() && RotationCollector.mc.field_1687.method_18456().contains(this.lastTarget) && RotationCollector.mc.field_1724.method_5739(this.lastTarget) < 5.0f) {
            class_746 p = RotationCollector.mc.field_1724;
            float yaw = p.method_36454();
            float diffYaw = this.normalizeAngle(yaw - this.lastYaw);
            float targetYaw = this.calcTargetDeltaYaw(p, this.lastTarget);
            if (Math.abs(diffYaw) < 50.0f || Math.signum(diffYaw) == Math.signum(targetYaw)) {
                event.getContext().drawCenteredText(Fonts.MEDIUM.getFont(8.0f), "Recording", sr.getScaledWidth() / 2.0f, 40.0f, ColorRGBA.WHITE);
            }
        }
    };
    private final EventListener<ClientPlayerTickEvent> onPlayerTick = event -> {
        class_746 p = class_310.method_1551().field_1724;
        if (p != null) {
            long now = System.currentTimeMillis();
            float yaw = p.method_36454();
            float pitch = p.method_36455();
            float diffYaw = this.normalizeAngle(yaw - this.lastYaw);
            float diffPitch = this.normalizeAngle(pitch - this.lastPitch);
            float distance = -999.0f;
            float targetYaw = -999.0f;
            float targetPitch = -999.0f;
            if (this.lastTarget != null && now - this.lastSwingTimeMs <= 1500L && this.lastTarget.method_5805() && RotationCollector.mc.field_1687.method_18456().contains(this.lastTarget) && RotationCollector.mc.field_1724.method_5739(this.lastTarget) < 5.0f) {
                distance = p.method_5739(this.lastTarget);
                targetYaw = this.calcTargetDeltaYaw(p, this.lastTarget);
                targetPitch = this.calcTargetDeltaPitch(p, this.lastTarget);
                float diffY = (float)(RotationCollector.mc.field_1724.method_23318() - this.lastTarget.method_23318());
                if (Math.abs(targetYaw) < 30.0f || Math.signum(diffYaw) == Math.signum(targetYaw)) {
                    HashMap<String, Number> rec = new HashMap<String, Number>();
                    rec.put("deltaYaw", Float.valueOf(diffYaw));
                    rec.put("deltaPitch", Float.valueOf(diffPitch));
                    rec.put("timeSinceLastHitMs", now - this.lastSwingTimeMs);
                    rec.put("distance", Float.valueOf(distance));
                    rec.put("fallDistance", Float.valueOf(RotationCollector.mc.field_1724.field_6017));
                    rec.put("diffY", Float.valueOf(diffY));
                    rec.put("targetDeltaYaw", Float.valueOf(targetYaw));
                    rec.put("targetDeltaPitch", Float.valueOf(targetPitch));
                    rec.put("prevTargetYaw", Float.valueOf(this.prevTargetYaw == -999.0f ? targetYaw : this.prevTargetYaw));
                    rec.put("prevTargetPitch", Float.valueOf(this.prevTargetPitch == -999.0f ? targetPitch : this.prevTargetPitch));
                    rec.put("prevYaw", Float.valueOf(this.prevYaw));
                    rec.put("prevPitch", Float.valueOf(this.prevPitch));
                    rec.put("prevDistance", Float.valueOf(this.prevDistance == -999.0f ? distance : this.prevDistance));
                    this.dataset.add(rec);
                }
            }
            this.prevTargetYaw = targetYaw;
            this.prevTargetPitch = targetPitch;
            this.prevYaw = diffYaw;
            this.prevPitch = diffPitch;
            this.prevDistance = distance;
            if (this.lastTarget != null && now - this.lastSwingTimeMs > 1500L && !this.dataset.isEmpty()) {
                this.dumpToJson();
                this.dataset.clear();
                this.lastTarget = null;
            }
            this.lastYaw = p.method_36454();
            this.lastPitch = p.method_36455();
        }
    };

    private void dumpToJson() {
        Path out = class_310.method_1551().field_1697.toPath().resolve("C:/Rockstar/kill_aura_dataset.json");
        try (FileWriter writer = new FileWriter(out.toFile(), true);){
            Gson gson = new GsonBuilder().create();
            writer.write(gson.toJson(this.dataset));
            writer.write("\n");
        }
        catch (IOException var7) {
            var7.printStackTrace();
        }
    }

    private float normalizeAngle(float angle) {
        if ((angle %= 360.0f) > 180.0f) {
            angle -= 360.0f;
        }
        if (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private float calcTargetDeltaYaw(class_746 p, class_1297 t) {
        double dx = t.method_23317() - p.method_23317();
        double dz = t.method_23321() - p.method_23321();
        float targetYaw = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0);
        return this.normalizeAngle(targetYaw - p.method_36454());
    }

    private float calcTargetDeltaPitch(class_746 p, class_1297 t) {
        double dx = t.method_23317() - p.method_23317();
        double dz = t.method_23321() - p.method_23321();
        double dy = t.method_23320() - p.method_23320();
        double dist = Math.sqrt(dx * dx + dz * dz);
        float targetPitch = (float)(-Math.toDegrees(Math.atan2(dy, dist)));
        return this.normalizeAngle(targetPitch - p.method_36455());
    }
}

